<?php
$page_title = "Emergency Response - HeatGuard";
$additional_css = ['assets/css/emergency-response.css'];
$additional_js = ['assets/js/emergency-response.js'];

$user = [
    'name' => 'Officer Jerome Buntalidad',
    'role' => 'Traffic Enforcer',
    'department' => 'Bacolod TMU',
    'badge' => 'TMU-2024-001',
    'status' => 'on_duty'
];

$current_heat_index = 42;
$heat_level = 'DANGER';

$emergency_types = [
    'heat_exhaustion' => [
        'name' => 'Heat Exhaustion',
        'icon' => 'fa-thermometer-three-quarters',
        'color' => 'orange',
        'symptoms' => ['Heavy sweating', 'Weakness/fatigue', 'Dizziness', 'Nausea', 'Headache', 'Cool, moist skin']
    ],
    'heat_stroke' => [
        'name' => 'Heat Stroke',
        'icon' => 'fa-fire',
        'color' => 'red',
        'symptoms' => ['High body temperature', 'Hot, dry skin', 'Rapid pulse', 'Confusion', 'Loss of consciousness']
    ],
    'dehydration' => [
        'name' => 'Dehydration',
        'icon' => 'fa-tint',
        'color' => 'blue',
        'symptoms' => ['Extreme thirst', 'Dark urine', 'Fatigue', 'Dizziness', 'Dry mouth/skin']
    ],
    'general' => [
        'name' => 'General Emergency',
        'icon' => 'fa-exclamation-triangle',
        'color' => 'purple',
        'symptoms' => ['Other health concerns', 'Accident or injury', 'Equipment failure', 'Immediate assistance needed']
    ]
];

$recent_incidents = [
    [
        'id' => 'INC-2024-015',
        'officer' => 'Officer Martinez',
        'type' => 'Heat Exhaustion',
        'time' => '2:30 PM',
        'status' => 'Resolved',
        'location' => 'Lacson St. & 12th St.'
    ],
    [
        'id' => 'INC-2024-014',
        'officer' => 'Officer Cruz',
        'type' => 'Dehydration',
        'time' => '1:15 PM',
        'status' => 'Under Treatment',
        'location' => 'Araneta Ave.'
    ],
    [
        'id' => 'INC-2024-013',
        'officer' => 'Officer Santos',
        'type' => 'Heat Exhaustion',
        'time' => '11:45 AM',
        'status' => 'Resolved',
        'location' => 'Capitol Area'
    ]
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link rel="stylesheet" href="assets/css/dashboard.css">
    <link rel="stylesheet" href="assets/css/emergency-response.css">
    <link rel="stylesheet" href="assets/css/main-footer.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
    <div class="dashboard-container">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <span class="logo-icon">🚦</span>
                    <span>HeatGuard</span>
                </div>
            </div>
            
            <nav class="sidebar-nav">
                <div class="nav-section">
                    <div class="nav-section-title">Main Dashboard</div>
                    <div class="nav-item">
                        <a href="dashboard.php" class="nav-link">
                            <i class="nav-icon fas fa-tachometer-alt"></i>
                            <span>Overview</span>
                        </a>
                    </div>
                </div>

                <div class="nav-section">
                    <div class="nav-section-title">Core Modules</div>
                    <div class="nav-item">
                        <a href="user-management.php" class="nav-link">
                            <i class="nav-icon fas fa-users"></i>
                            <span>User Management</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="heat-monitoring.php" class="nav-link">
                            <i class="nav-icon fas fa-thermometer-half"></i>
                            <span>Heat Index Monitoring</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="schedule-management.php" class="nav-link">
                            <i class="nav-icon fas fa-calendar-alt"></i>
                            <span>Schedule Management</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="safety-guidelines.php" class="nav-link">
                            <i class="nav-icon fas fa-shield-alt"></i>
                            <span>Safety Guidelines</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="emergency-response.php" class="nav-link active">
                            <i class="nav-icon fas fa-exclamation-triangle"></i>
                            <span>Emergency Response</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="reporting-system.php" class="nav-link">
                            <i class="nav-icon fas fa-chart-bar"></i>
                            <span>Automated Reports</span>
                        </a>
                    </div>
                </div>

                <div class="nav-section">
                    <div class="nav-section-title">Quick Actions</div>
                    <div class="nav-item">
                        <a href="#" class="nav-link" onclick="triggerEmergencyAlert()">
                            <i class="nav-icon fas fa-ambulance"></i>
                            <span>Emergency Alert</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="safety-guidelines.php" class="nav-link">
                            <i class="nav-icon fas fa-shield-alt"></i>
                            <span>Safety Guidelines</span>
                        </a>
                    </div>
                </div>

                <div class="nav-section">
                    <div class="nav-section-title">Account</div>
                    <div class="nav-item">
                        <a href="profile.php" class="nav-link">
                            <i class="nav-icon fas fa-user"></i>
                            <span>Profile Settings</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="index.php" class="nav-link">
                            <i class="nav-icon fas fa-sign-out-alt"></i>
                            <span>Logout</span>
                        </a>
                    </div>
                </div>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Top Bar -->
            <header class="top-bar">
                <div class="top-bar-left">
                    <button class="menu-toggle" id="menuToggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h1 class="page-title">Emergency Response Center</h1>
                </div>
                
                <div class="top-bar-right">
                    <div class="emergency-hotline">
                        <i class="fas fa-phone"></i>
                        <span>Emergency: 911</span>
                    </div>
                    
                    <div class="status-indicator <?php echo $user['status'] === 'on_duty' ? 'status-online' : 'status-offline'; ?>">
                        <i class="fas fa-circle"></i>
                        <?php echo $user['status'] === 'on_duty' ? 'On Duty' : 'Off Duty'; ?>
                    </div>
                    
                    <div class="user-menu">
                        <div class="user-avatar">
                            <?php echo strtoupper(substr($user['name'], 8, 1)) . strtoupper(substr($user['name'], 13, 1)); ?>
                        </div>
                        <div class="user-info">
                            <h4><?php echo explode(' ', $user['name'])[1] . ' ' . explode(' ', $user['name'])[2]; ?></h4>
                            <p><?php echo $user['role']; ?></p>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Emergency Response Content -->
            <div class="emergency-content">
                <!-- Emergency Alert Banner -->
                <div class="emergency-banner">
                    <div class="banner-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <div class="banner-content">
                        <h2>Emergency Response System</h2>
                        <p>Report incidents immediately • Get help fast • Save lives</p>
                    </div>
                    <button class="emergency-call-btn" onclick="callEmergency('911')">
                        <i class="fas fa-phone"></i>
                        Call 911
                    </button>
                </div>

                <!-- Quick Emergency Actions -->
                <div class="quick-emergency-grid">
                    <button class="emergency-btn btn-critical" onclick="triggerEmergencyAlert()">
                        <i class="fas fa-ambulance"></i>
                        <div class="btn-content">
                            <h3>CRITICAL EMERGENCY</h3>
                            <p>Immediate medical attention needed</p>
                        </div>
                    </button>
                    
                    <button class="emergency-btn btn-heat" onclick="reportHeatIncident()">
                        <i class="fas fa-thermometer-full"></i>
                        <div class="btn-content">
                            <h3>HEAT-RELATED INCIDENT</h3>
                            <p>Report heat exhaustion or heat stroke</p>
                        </div>
                    </button>
                    
                    <button class="emergency-btn btn-assistance" onclick="requestAssistance()">
                        <i class="fas fa-hands-helping"></i>
                        <div class="btn-content">
                            <h3>REQUEST ASSISTANCE</h3>
                            <p>Need immediate support or backup</p>
                        </div>
                    </button>
                </div>

                <!-- Emergency Report Form -->
                <div class="emergency-form-container">
                    <div class="form-header">
                        <h2><i class="fas fa-file-medical"></i> Submit Emergency Report</h2>
                        <p>Fill out this form to report an emergency incident</p>
                    </div>
                    
                    <form class="emergency-form" id="emergencyForm">
                        <div class="form-grid">
                            <div class="form-group">
                                <label for="incidentType">Incident Type <span class="required">*</span></label>
                                <select id="incidentType" name="incident_type" required>
                                    <option value="">Select incident type...</option>
                                    <?php foreach ($emergency_types as $key => $type): ?>
                                    <option value="<?php echo $key; ?>"><?php echo $type['name']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="severity">Severity Level <span class="required">*</span></label>
                                <select id="severity" name="severity" required>
                                    <option value="">Select severity...</option>
                                    <option value="low">Low - Minor assistance needed</option>
                                    <option value="medium">Medium - Medical attention required</option>
                                    <option value="high">High - Emergency response needed</option>
                                    <option value="critical">Critical - Life threatening</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="location">Location <span class="required">*</span></label>
                                <input type="text" id="location" name="location" placeholder="Exact location or nearest landmark" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="affectedOfficer">Affected Officer</label>
                                <input type="text" id="affectedOfficer" name="affected_officer" placeholder="Officer name or badge number">
                            </div>
                        </div>
                        
                        <div class="symptoms-section">
                            <h3><i class="fas fa-stethoscope"></i> Observed Symptoms</h3>
                            <div class="symptoms-grid" id="symptomsGrid">
                                <!-- Symptoms will be populated by JavaScript based on incident type -->
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="description">Detailed Description <span class="required">*</span></label>
                            <textarea id="description" name="description" rows="4" placeholder="Describe the incident in detail, including time of occurrence and current condition..." required></textarea>
                        </div>
                        
                        <div class="form-actions">
                            <button type="submit" class="btn-submit">
                                <i class="fas fa-paper-plane"></i>
                                Submit Emergency Report
                            </button>
                            <button type="button" class="btn-call-emergency" onclick="callEmergency('911')">
                                <i class="fas fa-phone"></i>
                                Call 911 Now
                            </button>
                        </div>
                    </form>
                </div>

                <!-- Recent Incidents -->
                <div class="recent-incidents">
                    <div class="incidents-header">
                        <h2><i class="fas fa-history"></i> Recent Incidents</h2>
                        <button class="btn-refresh" onclick="refreshIncidents()">
                            <i class="fas fa-sync-alt"></i>
                            Refresh
                        </button>
                    </div>
                    
                    <div class="incidents-table">
                        <table>
                            <thead>
                                <tr>
                                    <th>Incident ID</th>
                                    <th>Officer</th>
                                    <th>Type</th>
                                    <th>Time</th>
                                    <th>Location</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_incidents as $incident): ?>
                                <tr>
                                    <td><span class="incident-id"><?php echo $incident['id']; ?></span></td>
                                    <td><?php echo $incident['officer']; ?></td>
                                    <td>
                                        <span class="incident-type type-<?php echo strtolower(str_replace(' ', '-', $incident['type'])); ?>">
                                            <?php echo $incident['type']; ?>
                                        </span>
                                    </td>
                                    <td><?php echo $incident['time']; ?></td>
                                    <td><?php echo $incident['location']; ?></td>
                                    <td>
                                        <span class="status-badge status-<?php echo strtolower(str_replace(' ', '-', $incident['status'])); ?>">
                                            <?php echo $incident['status']; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <button class="btn-view" onclick="viewIncident('<?php echo $incident['id']; ?>')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn-follow-up" onclick="followUpIncident('<?php echo $incident['id']; ?>')">
                                            <i class="fas fa-clipboard-check"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Emergency Contacts Grid -->
                <div class="emergency-contacts-grid">
                    <div class="contact-card contact-911">
                        <div class="contact-header">
                            <i class="fas fa-ambulance"></i>
                            <h3>Emergency Services</h3>
                        </div>
                        <div class="contact-number">911</div>
                        <button class="btn-call" onclick="callEmergency('911')">Call Now</button>
                    </div>
                    
                    <div class="contact-card contact-hospital">
                        <div class="contact-header">
                            <i class="fas fa-hospital"></i>
                            <h3>Bacolod Medical Center</h3>
                        </div>
                        <div class="contact-number">(034) 433-6471</div>
                        <button class="btn-call" onclick="callEmergency('(034) 433-6471')">Call Now</button>
                    </div>
                    
                    <div class="contact-card contact-supervisor">
                        <div class="contact-header">
                            <i class="fas fa-user-tie"></i>
                            <h3>TMU Supervisor</h3>
                        </div>
                        <div class="contact-number">(034) 445-5555</div>
                        <button class="btn-call" onclick="callEmergency('(034) 445-5555')">Call Now</button>
                    </div>
                    
                    <div class="contact-card contact-health">
                        <div class="contact-header">
                            <i class="fas fa-heartbeat"></i>
                            <h3>Health Department</h3>
                        </div>
                        <div class="contact-number">(034) 441-1234</div>
                        <button class="btn-call" onclick="callEmergency('(034) 441-1234')">Call Now</button>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Emergency Alert Modal -->
    <div id="emergencyModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h2><i class="fas fa-exclamation-triangle"></i> Emergency Alert Triggered</h2>
            </div>
            <div class="modal-body">
                <p>Emergency services have been notified. Help is on the way.</p>
                <div class="emergency-info">
                    <p><strong>Location:</strong> <span id="emergencyLocation">Detecting location...</span></p>
                    <p><strong>Time:</strong> <span id="emergencyTime"><?php echo date('h:i A'); ?></span></p>
                    <p><strong>Response Team:</strong> Dispatched</p>
                </div>
            </div>
            <div class="modal-actions">
                <button class="btn-primary" onclick="closeModal()">OK</button>
                <button class="btn-danger" onclick="callEmergency('911')">Call 911</button>
            </div>
        </div>
    </div>

    <script src="assets/js/dashboard.js"></script>
    <script src="assets/js/emergency-response.js"></script>
    
    <!-- Pass PHP data to JavaScript -->
    <script>
        window.emergencyTypes = <?php echo json_encode($emergency_types); ?>;
    </script>
     <?php include 'main-footer.php'; ?>
</body>
</html>