<?php
$page_title = "Automated Reports - HeatGuard";
$additional_css = ['assets/css/reporting-system.css'];
$additional_js = ['assets/js/reporting-system.js'];

$user = [
    'name' => 'Officer Jerome Buntalidad',
    'role' => 'Traffic Enforcer',
    'department' => 'Bacolod TMU',
    'badge' => 'TMU-2024-001',
    'status' => 'on_duty'
];

$report_data = [
    'total_reports' => 156,
    'monthly_reports' => 23,
    'weekly_reports' => 6,
    'pending_reports' => 3,
    'heat_incidents' => 12,
    'exposure_violations' => 8,
    'emergency_responses' => 4
];

$recent_reports = [
    [
        'id' => 'RPT-2024-156',
        'type' => 'Heat Exposure Report',
        'date' => '2024-09-07',
        'status' => 'completed',
        'officers_affected' => 5,
        'max_heat_index' => 42
    ],
    [
        'id' => 'RPT-2024-155',
        'type' => 'Incident Summary',
        'date' => '2024-09-06',
        'status' => 'pending',
        'officers_affected' => 2,
        'max_heat_index' => 38
    ],
    [
        'id' => 'RPT-2024-154',
        'type' => 'Weekly Safety Report',
        'date' => '2024-09-05',
        'status' => 'completed',
        'officers_affected' => 20,
        'max_heat_index' => 41
    ]
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?></title>
    <link rel="stylesheet" href="assets/css/reporting-system.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
    <div class="dashboard-container">
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <span class="logo-icon">🚦</span>
                    <span>HeatGuard</span>
                </div>
            </div>
            
            <nav class="sidebar-nav">
                <div class="nav-section">
                    <div class="nav-section-title">Main Dashboard</div>
                    <div class="nav-item">
                        <a href="dashboard.php" class="nav-link">
                            <i class="nav-icon fas fa-tachometer-alt"></i>
                            <span>Overview</span>
                        </a>
                    </div>
                </div>

                <div class="nav-section">
                    <div class="nav-section-title">Core Modules</div>
                    <div class="nav-item">
                        <a href="user-management.php" class="nav-link">
                            <i class="nav-icon fas fa-users"></i>
                            <span>User Management</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="heat-monitoring.php" class="nav-link">
                            <i class="nav-icon fas fa-thermometer-half"></i>
                            <span>Heat Index Monitoring</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="schedule-management.php" class="nav-link">
                            <i class="nav-icon fas fa-calendar-alt"></i>
                            <span>Schedule Management</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="safety-guidelines.php" class="nav-link">
                            <i class="nav-icon fas fa-shield-alt"></i>
                            <span>Safety Guidelines</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="emergency-response.php" class="nav-link">
                            <i class="nav-icon fas fa-exclamation-triangle"></i>
                            <span>Emergency Response</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="reporting-system.php" class="nav-link active">
                            <i class="nav-icon fas fa-chart-bar"></i>
                            <span>Automated Reports</span>
                        </a>
                    </div>
                </div>

                <div class="nav-section">
                    <div class="nav-section-title">Quick Actions</div>
                    <div class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-ambulance"></i>
                            <span>Emergency Alert</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="nav-icon fas fa-file-download"></i>
                            <span>Export Reports</span>
                        </a>
                    </div>
                </div>

                <div class="nav-section">
                    <div class="nav-section-title">Account</div>
                    <div class="nav-item">
                        <a href="profile.php" class="nav-link">
                            <i class="nav-icon fas fa-user"></i>
                            <span>Profile Settings</span>
                        </a>
                    </div>
                    <div class="nav-item">
                        <a href="index.php" class="nav-link">
                            <i class="nav-icon fas fa-sign-out-alt"></i>
                            <span>Logout</span>
                        </a>
                    </div>
                </div>
            </nav>
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            <!-- Top Bar -->
            <header class="top-bar">
                <div class="top-bar-left">
                    <button class="menu-toggle" id="menuToggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h1 class="page-title">Automated Reporting System</h1>
                </div>
                
                <div class="top-bar-right">
                    <div class="status-indicator <?php echo $user['status'] === 'on_duty' ? 'status-online' : 'status-offline'; ?>">
                        <i class="fas fa-circle"></i>
                        <?php echo $user['status'] === 'on_duty' ? 'On Duty' : 'Off Duty'; ?>
                    </div>
                    
                   <div class="user-menu">
                        <div class="user-avatar">
                            <?php echo strtoupper(substr($user['name'], 8, 1)) . strtoupper(substr($user['name'], 13, 1)); ?>
                        </div>
                        <div class="user-info">
                            <h4><?php echo explode(' ', $user['name'])[1] . ' ' . explode(' ', $user['name'])[2]; ?></h4>
                            <p><?php echo $user['role']; ?></p>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Reports Content -->
            <div class="reports-content">
                <!-- Report Statistics -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon icon-total">
                            <i class="fas fa-file-alt"></i>
                        </div>
                        <div class="stat-info">
                            <h3><?php echo $report_data['total_reports']; ?></h3>
                            <p>Total Reports</p>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon icon-monthly">
                            <i class="fa-solid fa-calendar"></i>
                        </div>
                        <div class="stat-info">
                            <h3><?php echo $report_data['monthly_reports']; ?></h3>
                            <p>This Month</p>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon icon-weekly">
                            <i class="fas fa-calendar-week"></i>
                        </div>
                        <div class="stat-info">
                            <h3><?php echo $report_data['weekly_reports']; ?></h3>
                            <p>This Week</p>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon icon-pending">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="stat-info">
                            <h3><?php echo $report_data['pending_reports']; ?></h3>
                            <p>Pending Reports</p>
                        </div>
                    </div>
                </div>

                <!-- Report Generation Panel -->
                <div class="report-panel">
                    <div class="panel-header">
                        <h2><i class="fas fa-plus-circle"></i> Generate New Report</h2>
                        <p>Create automated reports based on system data and user inputs</p>
                    </div>
                    
                    <div class="report-types">
                        <div class="report-type-card" onclick="generateReport('heat-exposure')">
                            <div class="report-type-icon">
                                <i class="fas fa-thermometer-half"></i>
                            </div>
                            <h3>Heat Exposure Report</h3>
                            <p>Analysis of officer heat exposure duration and safety compliance</p>
                            <div class="report-meta">
                                <span><i class="fas fa-users"></i> All Officers</span>
                                <span><i class="fas fa-clock"></i> Daily/Weekly</span>
                            </div>
                        </div>
                        
                        <div class="report-type-card" onclick="generateReport('incident-summary')">
                            <div class="report-type-icon">
                                <i class="fas fa-exclamation-triangle"></i>
                            </div>
                            <h3>Incident Summary</h3>
                            <p>Comprehensive report of heat-related incidents and emergency responses</p>
                            <div class="report-meta">
                                <span><i class="fas fa-chart-line"></i> <?php echo $report_data['heat_incidents']; ?> Incidents</span>
                                <span><i class="fas fa-ambulance"></i> <?php echo $report_data['emergency_responses']; ?> Responses</span>
                            </div>
                        </div>
                        
                        <div class="report-type-card" onclick="generateReport('safety-compliance')">
                            <div class="report-type-icon">
                                <i class="fas fa-shield-alt"></i>
                            </div>
                            <h3>Safety Compliance Report</h3>
                            <p>Evaluation of safety protocol adherence and violation tracking</p>
                            <div class="report-meta">
                                <span><i class="fas fa-check-circle"></i> Compliance Rate</span>
                                <span><i class="fas fa-times-circle"></i> <?php echo $report_data['exposure_violations']; ?> Violations</span>
                            </div>
                        </div>
                        
                        <div class="report-type-card" onclick="generateReport('performance-analytics')">
                            <div class="report-type-icon">
                                <i class="fas fa-chart-bar"></i>
                            </div>
                            <h3>Performance Analytics</h3>
                            <p>Statistical analysis of system performance and officer wellbeing metrics</p>
                            <div class="report-meta">
                                <span><i class="fas fa-trendline"></i> Trends</span>
                                <span><i class="fas fa-database"></i> Analytics</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Reports -->
                <div class="recent-reports">
                    <div class="section-header">
                        <h2><i class="fas fa-history"></i> Recent Reports</h2>
                        <div class="report-filters">
                            <select class="filter-select">
                                <option value="all">All Reports</option>
                                <option value="heat-exposure">Heat Exposure</option>
                                <option value="incidents">Incidents</option>
                                <option value="safety">Safety Compliance</option>
                            </select>
                            <button class="filter-btn"><i class="fas fa-search"></i></button>
                        </div>
                    </div>
                    
                    <div class="reports-table">
                        <div class="table-header">
                            <div class="table-col">Report ID</div>
                            <div class="table-col">Type</div>
                            <div class="table-col">Date Generated</div>
                            <div class="table-col">Status</div>
                            <div class="table-col">Officers</div>
                            <div class="table-col">Max Heat Index</div>
                            <div class="table-col">Actions</div>
                        </div>
                        
                        <?php foreach ($recent_reports as $report): ?>
                        <div class="table-row">
                            <div class="table-col report-id"><?php echo $report['id']; ?></div>
                            <div class="table-col"><?php echo $report['type']; ?></div>
                            <div class="table-col"><?php echo date('M j, Y', strtotime($report['date'])); ?></div>
                            <div class="table-col">
                                <span class="status-badge status-<?php echo $report['status']; ?>">
                                    <?php echo ucfirst($report['status']); ?>
                                </span>
                            </div>
                            <div class="table-col"><?php echo $report['officers_affected']; ?></div>
                            <div class="table-col">
                                <span class="heat-indicator heat-<?php echo $report['max_heat_index'] >= 40 ? 'danger' : ($report['max_heat_index'] >= 35 ? 'caution' : 'safe'); ?>">
                                    <?php echo $report['max_heat_index']; ?>°C
                                </span>
                            </div>
                            <div class="table-col">
                                <div class="action-buttons">
                                    <button class="action-btn view-btn" title="View Report">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    <button class="action-btn download-btn" title="Download Report">
                                        <i class="fas fa-download"></i>
                                    </button>
                                    <button class="action-btn share-btn" title="Share Report">
                                        <i class="fas fa-share"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- Export Options -->
                <div class="export-panel">
                    <h3><i class="fas fa-file-export"></i> Export Options</h3>
                    <div class="export-buttons">
                        <button class="export-btn pdf-export">
                            <i class="fas fa-file-pdf"></i>
                            Export to PDF
                        </button>
                        <button class="export-btn excel-export">
                            <i class="fas fa-file-excel"></i>
                            Export to Excel
                        </button>
                        <button class="export-btn csv-export">
                            <i class="fas fa-file-csv"></i>
                            Export to CSV
                        </button>
                        <button class="export-btn email-export">
                            <i class="fas fa-envelope"></i>
                            Email Report
                        </button>
                    </div>
                </div>
            </div>
        </main>
    </div>
    <script src="assets/js/reporting-system.js"></script>
</body>
</html>